/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.preferencesdialog;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.nooj4nlp.controller.preferencesdialog.LexTableMouseListener;
import net.nooj4nlp.controller.preferencesdialog.SynTableMouseListener;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.components.CustomCell;
import net.nooj4nlp.gui.dialogs.PreferencesDialog;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class UpdateTablesListener {
    private JTable lvDic;
    private JTable lvMor;
    private JList lbAvailableSyntacticResources;
    private JTable lvSGrm;
    private PreferencesDialog dialog;
    private String docDirLex;
    private String docDirSyn;
    private String prjDirLex;
    private String prjDirSyn;

    public UpdateTablesListener(JTable lvDic, JTable lvMor, JList lbAvailableSyntacticResources, JTable lvSGrm, PreferencesDialog dialog) {
        this.lvDic = lvDic;
        this.lvMor = lvMor;
        this.dialog = dialog;
        this.lbAvailableSyntacticResources = lbAvailableSyntacticResources;
        this.lvSGrm = lvSGrm;
    }

    public void GetAllResourcesFromDisk(boolean projectmode, String languagename) {
        this.lvDic = this.dialog.getTableDictionary();
        DefaultTableModel dicModel = (DefaultTableModel)this.lvDic.getModel();
        if (dicModel.getRowCount() > 0) {
            dicModel.getDataVector().removeAllElements();
            dicModel.fireTableDataChanged();
        }
        this.lvDic.addMouseListener(new LexTableMouseListener(this.lvDic, this.lvMor, this.dialog, true));
        this.lvMor = this.dialog.getTableMorphology();
        DefaultTableModel morModel = (DefaultTableModel)this.lvMor.getModel();
        if (morModel.getRowCount() > 0) {
            morModel.getDataVector().removeAllElements();
            morModel.fireTableDataChanged();
        }
        this.lvMor.addMouseListener(new LexTableMouseListener(this.lvDic, this.lvMor, this.dialog, false));
        this.lvSGrm = this.dialog.getTableResources();
        DefaultTableModel resModel = (DefaultTableModel)this.lvSGrm.getModel();
        this.lvSGrm.addMouseListener(new SynTableMouseListener(this.lvSGrm, this.lbAvailableSyntacticResources, this.dialog, false));
        this.lbAvailableSyntacticResources = this.dialog.getListSynResources();
        DefaultListModel listModel = (DefaultListModel)this.lbAvailableSyntacticResources.getModel();
        if (listModel.size() > 0) {
            listModel.clear();
        }
        this.lbAvailableSyntacticResources.addMouseListener(new SynTableMouseListener(this.lvSGrm, this.lbAvailableSyntacticResources, this.dialog, true));
        boolean loadprojectresources = false;
        if (projectmode) {
            String zname = FilenameUtils.concat(Paths.projectDir, languagename);
            File dir = new File(zname);
            loadprojectresources = dir.isDirectory();
        }
        if (!loadprojectresources) {
            this.docDirLex = Paths.docDir + System.getProperty("file.separator") + languagename + System.getProperty("file.separator") + "Lexical Analysis";
            File ldir = new File(this.docDirLex);
            if (!ldir.isDirectory()) {
                ldir.mkdirs();
            } else {
                String[] list;
                this.lvDic.getColumn("Dictionary").setCellRenderer(new CellEditorRenderer());
                this.lvDic.getColumn("Dictionary").setCellEditor(new CellEditorRenderer());
                this.lvMor.getColumn("Morphology").setCellRenderer(new CellEditorRenderer());
                this.lvMor.getColumn("Morphology").setCellEditor(new CellEditorRenderer());
                for (String file : list = ldir.list()) {
                    File f;
                    CustomCell value;
                    String ext = FilenameUtils.getExtension(file);
                    if (ext.equalsIgnoreCase("jnod")) {
                        value = new CustomCell();
                        value.label.setText(file);
                        value.label.setSize(value.label.getPreferredSize().width, value.label.getPreferredSize().height);
                        f = new File(this.docDirLex + System.getProperty("file.separator") + file.substring(0, file.lastIndexOf(".")) + "jnod");
                        if (f.exists()) {
                            value.setForeground(Color.RED);
                        }
                        dicModel.addRow(new Object[]{value, ""});
                        continue;
                    }
                    if (!ext.equalsIgnoreCase("nom")) continue;
                    value = new CustomCell();
                    value.label.setText(file);
                    value.label.setSize(value.label.getPreferredSize().width, value.label.getPreferredSize().height);
                    f = new File(this.docDirLex + System.getProperty("file.separator") + file.substring(0, file.lastIndexOf(".")) + "nom");
                    if (f.exists()) {
                        value.setForeground(Color.RED);
                    }
                    morModel.addRow(new Object[]{value, ""});
                }
            }
            this.docDirSyn = Paths.docDir + System.getProperty("file.separator") + languagename + System.getProperty("file.separator") + "Syntactic Analysis";
            File sdir = new File(this.docDirSyn);
            if (!sdir.isDirectory()) {
                sdir.mkdirs();
            } else {
                String[] list;
                for (String file : list = sdir.list()) {
                    String ext = FilenameUtils.getExtension(file);
                    if (!ext.equalsIgnoreCase("nog")) continue;
                    listModel.addElement(file);
                }
            }
        } else {
            this.lvDic.getColumn("Dictionary").setCellRenderer(new CellEditorRenderer());
            this.lvDic.getColumn("Dictionary").setCellEditor(new CellEditorRenderer());
            this.lvMor.getColumn("Morphology").setCellRenderer(new CellEditorRenderer());
            this.lvMor.getColumn("Morphology").setCellEditor(new CellEditorRenderer());
            String lexName = FilenameUtils.concat(Paths.projectDir, FilenameUtils.concat(languagename, "Lexical Analysis"));
            File lexDir = new File(lexName);
            this.prjDirLex = lexDir.exists() ? lexName : FilenameUtils.concat(Paths.projectDir, languagename);
            File tempDir = new File(this.prjDirLex);
            for (File file : tempDir.listFiles()) {
                String fullName = file.getName();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Resource file " + fullName + " does not exist.", "NooJ: Project file is invalid", 1);
                    continue;
                }
                String dName = file.getParent();
                String fName = fullName;
                String fName2 = fName.substring(2);
                String ext = FilenameUtils.getExtension(fullName);
                if (ext.equalsIgnoreCase("jnod")) {
                    Color c = Color.black;
                    String nogFileName = FilenameUtils.concat(dName, FilenameUtils.concat(FilenameUtils.removeExtension(fullName), "nog"));
                    File nogFile = new File(nogFileName);
                    if (nogFile.exists()) {
                        c = Color.red;
                    }
                    CustomCell value = new CustomCell();
                    value.label.setText(fName2);
                    value.label.setSize(value.label.getPreferredSize().width, value.label.getPreferredSize().height);
                    value.setForeground(c);
                    dicModel.addRow(new Object[]{value, ""});
                    continue;
                }
                if (!ext.equalsIgnoreCase("nom")) continue;
                morModel.addRow(new Object[]{new JCheckBox(fName2), ""});
            }
            this.lvSGrm.getColumn("Grammar").setCellRenderer(new CellEditorRenderer());
            this.lvSGrm.getColumn("Grammar").setCellEditor(new CellEditorRenderer());
            String synName = FilenameUtils.concat(Paths.projectDir, FilenameUtils.concat(languagename, "Syntactic Analysis"));
            File synDir = new File(synName);
            this.prjDirSyn = synDir.exists() ? synName : FilenameUtils.concat(Paths.projectDir, languagename);
            tempDir = new File(this.prjDirSyn);
            for (File file : tempDir.listFiles()) {
                String fullName = file.getName();
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Resource file " + fullName + " does not exist.", "NooJ: Project file is invalid", 1);
                    continue;
                }
                String fName = fullName;
                String pref = fName.substring(0, 2);
                String fName2 = fName.substring(2);
                String ext = FilenameUtils.getExtension(fullName);
                if (!ext.equalsIgnoreCase("nog")) continue;
                resModel.addRow(new Object[]{pref, fName2});
                listModel.addElement(fName2);
            }
        }
    }

    public void GetAllResourcesFromPref(String languagename) {
        String ext;
        int i;
        ArrayList<String> f = Launcher.preferences.ldic.get(languagename);
        if (f != null) {
            for (i = 0; i < f.size(); ++i) {
                String prefname = f.get(i);
                ext = FilenameUtils.getExtension(prefname);
                if (ext.equalsIgnoreCase("jnod")) {
                    this.CheckPrefResourceInLvLex(prefname, this.dialog.getTableDictionary());
                    continue;
                }
                if (!ext.equalsIgnoreCase("nom")) continue;
                this.CheckPrefResourceInLvLex(prefname, this.dialog.getTableMorphology());
            }
        }
        if ((f = Launcher.preferences.lsyn.get(languagename)) != null) {
            for (i = 0; i < f.size(); ++i) {
                String prefName = f.get(i);
                ext = FilenameUtils.getExtension(prefName);
                if (!ext.equalsIgnoreCase("nog")) continue;
                String pref = prefName.substring(0, 2);
                String fName = prefName.substring(2);
                int prio = 0;
                prio = Integer.parseInt(pref);
                if (prio == 0) continue;
                this.CheckPrefResourceInLvSyn(fName, prio, this.lvSGrm);
            }
        }
    }

    private void CheckPrefResourceInLvLex(String prefname, JTable lv) {
        String fName = prefname;
        String prio = "";
        if (lv == this.lvSGrm) {
            prio = fName.substring(0, 2);
            if (Character.isDigit(prio.charAt(0))) {
                if (Character.isDigit(prio.charAt(1))) {
                    fName = fName.substring(1);
                } else {
                    prio = prio.substring(0, 1);
                    fName = fName.substring(1);
                }
            }
            if (prio.equals("0") || prio.equals("00")) {
                prio = "";
            }
        } else {
            int priority;
            String prefx = fName.substring(0, 2);
            try {
                priority = Integer.parseInt(prefx);
            }
            catch (Exception e) {
                priority = 0;
            }
            prio = priority < 0 ? "H" + String.valueOf(-priority) : (priority > 0 ? "L" + String.valueOf(priority) : "");
            fName = fName.substring(2);
        }
        DefaultTableModel model = (DefaultTableModel)lv.getModel();
        Vector<Vector> dataVector = model.getDataVector();
        Object[] data = dataVector.toArray();
        for (int i = 0; i < data.length; ++i) {
            Vector file = (Vector)data[i];
            CustomCell value = (CustomCell)file.get(0);
            String fname2 = value.label.getText();
            if (!fname2.equalsIgnoreCase(fName)) continue;
            value.checkBox.setSelected(true);
            model.setValueAt(value, i, 0);
            model.setValueAt(prio, i, 1);
            return;
        }
    }

    private void CheckPrefResourceInLvSyn(String fname, int priority, JTable lvSGrm) {
        DefaultTableModel model = (DefaultTableModel)lvSGrm.getModel();
        model.addRow(new Object[]{priority, fname});
    }

    class CellEditorRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private static final long serialVersionUID = -7918950819212313412L;
        private CustomCell renderer = new CustomCell();
        private CustomCell editor = new CustomCell();

        CellEditorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.renderer = (CustomCell)value;
            if (isSelected) {
                this.renderer.setBackground(table.getSelectionBackground());
            } else {
                this.renderer.setBackground(table.getBackground());
            }
            return this.renderer;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editor = (CustomCell)value;
            this.editor.setBackground(table.getSelectionBackground());
            return this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }
    }
}

